

% This file checks for deflation trap in the backward-looking model without
% shocks.

uuu = kappa^2+lambda*(1-beta*ksi^2) ;
VV = (- uuu + sqrt( uuu^2+4*lambda*ksi^2*beta*kappa^2))/(2*beta*kappa^2) ;
infl_pol_ss = lambda*ksi/(kappa^2*(1+beta*VV)+lambda) ;
output_pol_ss = -kappa*ksi*(1+beta*VV)/(kappa^2*(1+beta*VV)+lambda) ;

TTT = 500 ;
intpath_defl = zeros(TTT+1,1) ;
xpath_defl = zeros(TTT+1,1) ;
pipath_defl = zeros(TTT+1,1) ;
rhon_defl = rho_end*ones(TTT+1,1) ;
rhon_defl(1:T) = rhomean(1:T) ;
rhon_def(1:T2) = rhon_defl(1:T2) + min(std_epsX*grid_eps) ;
xpath_defl(1) = x0 ;
pipath_defl(1) = pi0 ;

for t=2:TTT+1
    
    J = rhon_defl(t) + pipath_defl(t-1) + sigma*delta*xpath_defl(t-1) - sigma*output_pol_ss*pipath_defl(t-1) ;
    
    if J<0.013
        intpath_defl(t) = ZLBI ;
    elseif J>=0.013
        intpath_defl(t) = J ;
    end
       
    xpath_defl(t) = delta*xpath_defl(t-1) - 1/sigma*(intpath_defl(t) - rhon_defl(t) - pipath_defl(t-1) ) ;
    pipath_defl(t) = ksi*pipath_defl(t-1) + kappa*xpath_defl(t) ;
    
end

if abs(pipath_defl(TTT))+abs(xpath_defl(TTT))>.1 ;
    disp('deflation trap')
    beep ; beep ; beep ;
    defltrapindicator = 1 ;
else
    defltrapindicator = 0 ;
end

% figure ; subplot(1,3,1) ; plot(xpath_defl,'LineWidth',2) ; title('x') ; subplot(1,3,2) ; plot(pipath_defl,'LineWidth',2); title('pi') ; subplot(1,3,3) ; plot(intpath_defl(2:TTT+1),'LineWidth',2) ; title('i')


    